﻿// ===== 添加上传表单 =====
(function () {
    var form = document.createElement("form");
    form.style.margin = "10px 0";
    form.innerHTML =
        "<input type='file' onchange='uploadFile(this)'>" +
        "<input type='submit' value='上传'>";
    document.body.insertBefore(form, document.body.firstChild);
})();

// ===== 上传文件（PUT） =====
async function uploadFile(input) {
    var file = input.files[0];
    if (!file) return;

    // 文件名 encodeURIComponent 分段编码
    let url = encodePath(file.name);

    await fetch(url, {
        method: "PUT",
        body: file,
        credentials: "include"
    });

    location.reload();
}

// ===== 删除 + 重命名按钮 =====
document.addEventListener("DOMContentLoaded", () => {
    document.querySelectorAll("pre a").forEach(a => {
        var href = a.getAttribute("href");

        if (href === "../") return;

        let isFolder = href.endsWith("/");

        // ---------- 删除按钮 ----------
        var btnDel = document.createElement("button");
        btnDel.textContent = "删除";
        btnDel.style.marginLeft = "10px";
        btnDel.onclick = async () => {
            if (confirm("删除 " + href + " ?")) {
                let url = encodePath(href);
                await fetch(url, { method: "DELETE", credentials: "include" });
                location.reload();
            }
        };
        a.parentNode.insertBefore(btnDel, a.nextSibling);

        // ---------- 重命名按钮 ----------
        var btnRename = document.createElement("button");
        btnRename.textContent = "重命名";
        btnRename.style.marginLeft = "10px";
        btnRename.onclick = async () => {
            let defaultName = isFolder ? href.replace(/\/$/, "") : href;
            var newName = prompt("重命名为？", defaultName);
            if (!newName || newName === defaultName) return;

            if (isFolder) newName = newName.replace(/\/$/, "") + "/";

            // 当前目录
            var currentDir = location.pathname.replace(/[^/]+$/, "");

            // 源路径和目标路径分段编码
            var src = encodePath(href);
            var dest = encodePath(currentDir + newName);

            // 检查目标是否已存在
            let check = await fetch(dest, { method: "HEAD", credentials: "include" });
            if (check.ok) {
                alert("目标已存在，不能覆盖！");
                return;
            }

            await fetch(src, {
                method: "MOVE",
                headers: { "Destination": dest },
                credentials: "include"
            });

            location.reload();
        };
        a.parentNode.insertBefore(btnRename, btnDel.nextSibling);
    });
});

// ===== 工具函数：对路径每段编码，保留 '/' =====
function encodePath(path) {
    return path.split("/").map(segment => encodeURIComponent(segment)).join("/");
}
